<?php
/**
 * @version                    $id: $
 * @author                     JoomlaSun!
 * @package                    Joomla!
 * @subpackage                 mod_jun_portfolio
 * @copyright                  Copyright (C) 2014 - 2015 by JoomlaSUN. All rights reserved.
 * @license                    http://www.gnu.org/licenses/gpl-3.0.html GNU/GPL version 3, See LICENSE.txt
 */

// no direct access
defined('_JEXEC') or die('Restricted access');

$items = modJUNPortfolioHelper::getImagesFolder($params);

// Process item tags to filter
$filter_tags = array();

foreach($items as $item){
    foreach($item->tags as $tag){
        if(in_array($tag, $filter_tags) == false){
            array_push($filter_tags,$tag);
        }
    }
}

// var_dump($filter_tags);
// var_dump($items);
$content_background = $params->get('content_background');
// Process layout options
$column = $params->get('column');
$tablet = $params->get('tablet');
$mobile = $params->get('mobile');
$filter_position = $params->get('filter_position');
$padding = $params->get('padding');
$padding_value = $params->get('padding_value');
$style = '';
$style .= '.jun-portfolio-filters ul { text-align:' . $filter_position . ';}';
$style .= '.jun-item-content { background:' . $content_background . ';}';
$style .= '.jun-item { width:'. round(100/$column,20) . '%;}';
if($padding == 1 && $padding_value != ""){
    $style .= ' .jun-item { padding:' .$padding_value . '}';
}
$style.= '@media(max-width: 767px){' . ' .jun-item {width:' . round(100/$tablet,20) . '%;}}';
$style.= '@media(max-width: 479px){' . ' .jun-item {width:' . round(100/$mobile,20) . '%;}}';

// Process custom CSS
$document = JFactory::getDocument();
$custom_css = $params->get('custom_css');
$document->addStyleDeclaration($style);
$document->addStyleDeclaration($custom_css);

?>

<div id="jun-portfolio-<?php echo $module->id; ?>">
    <?php if($params->get('filter_category') == "1") : ?>
    <!-- Filter by tags -->
    <div class="jun-portfolio-filters clearfix">
        <ul data-option-key="filter" id="filter">
            <li class="jun-filter">
                <a class="selected " title="<?php echo JText::_('JUN_PORTFOLIO_FILTER_ALL')?>" data-option-value="*" href="#"><?php echo JText::_('JUN_PORTFOLIO_FILTER_ALL')?></a>
            </li>
            <?php foreach ($filter_tags as $tag): ?>
            <li class="jun-filter">
                <a title="<?php echo $tag; ?>" data-option-value=".<?php echo $tag; ?>" href="#"><?php echo $tag; ?></a>
            </li>
            <?php endforeach; ?>
        </ul>
    </div>
    <?php endif; ?>
    <?php if(count($items) > 0 ): ?>
    <!-- Porfolio Content -->
    <div id="jun-portfolio-items-<?php echo $module->id; ?>">
        <?php foreach($items as $item): ?>
        <div class="jun-item <?php foreach($item->tags as $tag){ echo " ".$tag; } ; ?>">
            <div class="jun-item-image">
                <div class="effect-julia">
                    <img src="<?php echo JUri::base().$item->imagesrc; ?>" alt="<?php echo $item->title; ?>" />
                    <div class="jun-hover-icon">
                        <div class="jun-icon icon-lightbox"><a href="#jun-portfolio-<?php echo $item->position; ?>" class="open-popup-link"><i class="fa fa-plus"></i></a></div>
                        <div class="jun-icon icon-url"><a href="<?php echo $item->url; ?>" target="<?php echo $item->urlTarget; ?>"><i class="fa fa-link"></i></a></div>
                    </div>    
                </div>
            </div>
            <?php if(($params->get('show_title')==1) || ($params->get('show_description')==1) || ($params->get('show_readmore')==1) ) : ?>
            <div class="jun-item-content">
                <?php if($params->get('show_title')==1) : ?>
                <div class="jun-content-title"><?php echo $item->title; ?></div>
                <?php endif; ?>
                <?php if($params->get('show_description')==1) : ?>
                <div class="jun-content-description"><?php echo modJUNPortfolioHelper::limit_words($item->description,$params->get("description_limit_word")); ?></div>
                <?php endif; ?>
                <?php if($params->get('show_readmore')==1) : ?>
                <div class="jun-content-more"><a href="<?php echo $item->url; ?>" target="<?php echo $item->urlTarget; ?>"><?php echo JText::_('JUN_PORTFOLIO_READMORE')?></a></div>
                <?php endif; ?>
            </div>
            <?php endif; ?>
            <!-- Portfolio popup -->
            <div id="jun-portfolio-<?php echo $item->position; ?>" class="white-popup mfp-hide">
                <div class="content-popup">
                    <div class="jun-image-popup">
                        <img src="<?php echo JUri::base().$item->imagesrc; ?>" title="<?php echo $item->title; ?>" alt="<?php echo $item->title; ?>" />
                    </div>
                    <div class="jun-content-popup">
                        <h3><?php echo $item->title; ?></h3>
                        <p>
                        <?php echo $item->description; ?>
                        </p>
                        <a href="<?php echo $item->url; ?>" class="jun-lb-more" target="<?php echo $item->urlTarget; ?>"><?php echo JText::_('JUN_PORTFOLIO_READMORE')?></a>
                    </div> 
                </div>
                
            </div>
        </div>
        <?php endforeach; ?>
    </div>
    <?php endif; ?>
</div>
<script>
    !function($){
        $(document).ready(function(){
            var $container = $('#jun-portfolio-items-<?php echo $module->id; ?>');
            // layout Isotope after each image loads
            $container.imagesLoaded().progress( function() {
                $container.isotope({
                    // options
                    itemSelector : '.jun-item',
                    layoutMode : 'masonry'
                });
                var imgLoad = imagesLoaded( $container );
                imgLoad.on( 'always', function( instance ) {
                    console.log('all images are loaded');
                });
            });
            
            // bind filter button click
            $('.jun-portfolio-filters').on( 'click', 'a', function() {
                var filterValue = jQuery( this ).attr('data-option-value');
                $container.isotope({ filter: filterValue });
            });
            // filter class
            $("ul#filter>li a:first").addClass('active');
            $('.jun-portfolio-filters li a').on('click', function (e) {
                e.preventDefault();
                $('.jun-portfolio-filters li a.active').removeClass('active');
                $(this).addClass('active');
            });
            // magfinic popup
            $('.open-popup-link').magnificPopup({
                gallery: {
                  enabled: true, // set to true to enable gallery

                  preload: [0,2], // read about this option in next Lazy-loading section

                  navigateByImgClick: true,

                  arrowMarkup: '<button title="%title%" type="button" class="mfp-arrow mfp-arrow-%dir%"></button>', // markup of an arrow button

                  tPrev: 'Previous (Left arrow key)', // title for left button
                  tNext: 'Next (Right arrow key)', // title for right button
                  tCounter: '<span class="mfp-counter">%curr% of %total%</span>' // markup of counter
                },
                image: {
                    // options for image content type
                    titleSrc: 'title'
                },
                type:'inline',
                alignTop:false,
                closeBtnInside:true,
                midClick: true // Allow opening popup on middle mouse click. Always set it to true if you don't provide alternative source in href.
            });
        });
    }(jQuery);
</script>